package com.ejie.aa17a.view.excel;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import com.ejie.aa17a.informes.Aa17aInformesExcel;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aInformeFiltro;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * 
 * @author francisco.galvez
 * 
 */
public class Aa17aExcelView extends AbstractExcelView {

	private ReloadableResourceBundleMessageSource viewsMessageSource;

	/**
	 * 
	 * @param model
	 *            map
	 * @param wb
	 *            HSSFWorkbook
	 * @param req
	 *            HttpServletRequest
	 * @param resp
	 *            HttpServletResponse
	 * @throws Exception
	 *             e
	 */
	protected void buildExcelDocument(
			Map<String, Object> model,
			HSSFWorkbook wb,
			HttpServletRequest req,
			HttpServletResponse resp)
			throws Exception {

		Aa17aInformesExcel aa17aInformesExcel = new Aa17aInformesExcel(this.viewsMessageSource.getParentMessageSource());

		Integer tipoInforme = (Integer) model.get("tipoInforme");
		Aa17aInformeFiltro informeFiltro = (Aa17aInformeFiltro) model.get("filtro");

		if (Aa17aConstantes.INFORME_DATOS_HORARIOS.equals(tipoInforme)) {
			@SuppressWarnings(value = "unchecked")
			List<Aa17aDatoHorario> listDatosHorarios = (List<Aa17aDatoHorario>) model.get("datos");
			aa17aInformesExcel.informeDatosHorarios(wb, listDatosHorarios, informeFiltro);

		}
		else if (Aa17aConstantes.INFORME_DATOS_HISTORICOS_DIARIO.equals(tipoInforme)) {
			@SuppressWarnings(value = "unchecked")
			List<Aa17aDatoHistorico> listDatosHistoricos = (List<Aa17aDatoHistorico>) model.get("datos");
			aa17aInformesExcel.informeDatosHistoricoDiarios(wb, listDatosHistoricos, informeFiltro);
		}
		else if (Aa17aConstantes.INFORME_DATOS_HISTORICOS_HORARIO.equals(tipoInforme)) {
			@SuppressWarnings(value = "unchecked")
			List<Aa17aDatoHorario> listDatosHorarios = (List<Aa17aDatoHorario>) model.get("datos");
			aa17aInformesExcel.informeDatosHistoricoHorarios(wb, listDatosHorarios, informeFiltro);
		}

	}

	/**
	 * @param viewsMessageSource
	 *            the viewsMessageSource to set
	 */
	public void setViewsMessageSource(ReloadableResourceBundleMessageSource viewsMessageSource) {
		this.viewsMessageSource = viewsMessageSource;
	}

}